import com.ms.wfc.app.*;
import com.ms.wfc.core.*;
import com.ms.wfc.ui.*;
import com.ms.wfc.html.*;
import java.util.Hashtable;
import AutoComplete.trie;

/**
 * This class can take a variable number of parameters on the command
 * line. Program execution begins with the main() method. The class
 * constructor is not invoked unless an object of type 'Login'
 * created in the main() method.
 */
public class Login extends Form
{
	private trie m_userlist;
	private UserPass m_up;
	
	public UserPass getUserPass() {
		return m_up;
	}
	
	public trie getUserlist() {
		return m_userlist;
	}
	
	public Login(trie p_userlist)
	{
		super();

		// Required for Visual J++ Form Designer support
		initForm();		

		// TODO: Add any constructor code after initForm call
		m_userlist = p_userlist;
		if (m_userlist == null) {
			m_userlist = new trie();
	}
		
		edit1.setWordsTrie(m_userlist);
	}

	/**
	 * Login overrides dispose so it can clean up the
	 * component list.
	 */
	public void dispose()
	{
		super.dispose();
		components.dispose();
	}

	private void edit1_textChanged(Object source, Event e)
	{
		String temp = edit1.getText();
		UserPass up = (UserPass)m_userlist.get(temp);
		if(up != null) {
			if(up.getPassword() != null) {
				edit2.setText(up.getPassword());
				checkBox1.setChecked(true);
			} else {
				edit2.setText("");
				checkBox1.setChecked(false);
			}
		} else {
			edit2.setText("");
			checkBox1.setChecked(false);
		}
	}

	private void button1_click(Object source, Event e)
	{
		if (checkBox1.getChecked()) {
			UserPass up = (UserPass)m_userlist.get(edit1.getText());
			if (up == null) {
				up = new UserPass(edit1.getText(), edit2.getText());
				m_userlist.put(up.getUsername(), up);
			}
			else {
				m_userlist.remove(up.getUsername());
				up = new UserPass(edit1.getText(), edit2.getText());
				m_userlist.put(up.getUsername(), up);
			}
			m_up = up;
		} else {
			UserPass up = (UserPass)m_userlist.get(edit1.getText());
			if (up == null) {
				up = new UserPass(edit1.getText(), null);
				m_userlist.put(up.getUsername(), up);
			}
			else {
				m_userlist.remove(up.getUsername());
				up = new UserPass(edit1.getText(), null);
				m_userlist.put(up.getUsername(), up);
			}
			m_up = new UserPass(edit1.getText(), edit2.getText());
		}
		this.setDialogResult(DialogResult.OK);
	}

	private void button2_click(Object source, Event e)
	{
		this.setDialogResult(DialogResult.CANCEL);
	}

	/**
	 * NOTE: The following code is required by the Visual J++ form
	 * designer.  It can be modified using the form editor.  Do not
	 * modify it using the code editor.
	 */
	Container components = new Container();
	Button button1 = new Button();
	Label label1 = new Label();
	AutoComplete.autoList edit1 = new AutoComplete.autoList();
	CheckBox checkBox1 = new CheckBox();
	Edit edit2 = new Edit();
	Label label2 = new Label();
	Button button2 = new Button();

	private void initForm() { 
		// NOTE:  This form is storing resource information in an
		// external file.  Do not modify the string parameter to any
		// resources.getObject() function call. For example, do not
		// modify "foo1_location" in the following line of code
		// even if the name of the Foo object changes: 
		//   foo1.setLocation((Point)resources.getObject("foo1_location"));

		IResourceManager resources = new ResourceManager(this, "Login");
		button1.setLocation(new Point(144, 80));
		button1.setSize(new Point(75, 23));
		button1.setTabIndex(3);
		button1.setText("OK");
		button1.addOnClick(new EventHandler(this.button1_click));

		label1.setLocation(new Point(32, 15));
		label1.setSize(new Point(80, 16));
		label1.setTabIndex(6);
		label1.setTabStop(false);
		label1.setText("Username");

		edit1.setForeColor(Color.ACTIVEBORDER);
		edit1.setLocation(new Point(127, 12));
		edit1.setSize(new Point(184, 19));
		edit1.setTabIndex(0);
		edit1.setText("");
		edit1.addOnTextChanged(new EventHandler(this.edit1_textChanged));

		checkBox1.setLocation(new Point(32, 88));
		checkBox1.setSize(new Point(104, 16));
		checkBox1.setTabIndex(2);
		checkBox1.setText("Save Password");

		edit2.setLocation(new Point(127, 38));
		edit2.setSize(new Point(184, 20));
		edit2.setTabIndex(1);
		edit2.setText("");
		edit2.setAcceptsReturn(false);
		edit2.setPasswordChar('*');

		label2.setLocation(new Point(32, 40));
		label2.setSize(new Point(80, 16));
		label2.setTabIndex(5);
		label2.setTabStop(false);
		label2.setText("Password");

		button2.setLocation(new Point(232, 80));
		button2.setSize(new Point(75, 23));
		button2.setTabIndex(4);
		button2.setText("Cancel");
		button2.addOnClick(new EventHandler(this.button2_click));

		this.setText("Login");
		this.setAcceptButton(button1);
		this.setAutoScaleBaseSize(new Point(5, 13));
		this.setCancelButton(button2);
		this.setClientSize(new Point(338, 110));
		this.setControlBox(false);
		this.setIcon((Icon)resources.getObject("this_icon"));
		this.setKeyPreview(true);
		this.setStartPosition(FormStartPosition.CENTER_SCREEN);

		this.setNewControls(new Control[] {
							edit1, 
							button2, 
							label2, 
							edit2, 
							checkBox1, 
							label1, 
							button1});
	}

}
